// Configuration file for MVP Influencer Dashboard
// UPDATE THESE VALUES WITH YOUR ACTUAL CREDENTIALS

const CONFIG = {
    // Your backend API URL (deploy the backend first)
    // For local development: 'http://localhost:3000/api'
    // For production: 'https://your-app.herokuapp.com/api'
    API_BASE_URL: 'https://influencer-dashboard-backend.vercel.app/api',
    
    // Your secure API key (must match the one in your backend .env file)
    // Generate a random 32-character string for security
    API_SECRET_KEY: 'g9jmdx5srah6u1l9yy6o788ltps9gnx2',
    
    // Debug mode - set to false for production
    DEBUG_MODE: true,
    
    // Default sheet ranges for different data types
    SHEET_RANGES: {
        influencers: 'A1:E100'  // A=Profile pic, B=Name, C=Handle, D=Followers, E=Social Media
    }
};

function validateConfig() {
    const errors = [];
    
    // Check if it's still set to localhost (WRONG CHECK BEFORE)
    if (CONFIG.API_BASE_URL === 'http://localhost:3000/api') {
        errors.push('API_BASE_URL is still set to localhost - update for production');
    }
    
    // Check if it's still the placeholder value (WRONG CHECK BEFORE)
    if (CONFIG.API_SECRET_KEY === 'your-api-secret-key-here') {
        errors.push('API_SECRET_KEY not configured - set your actual secret key');
    }
    
    if (errors.length > 0 && CONFIG.DEBUG_MODE) {
        console.warn('Configuration issues:', errors);
    }
    
    return errors.length === 0;
}

// Environment detection
const isLocalhost = window.location.hostname === 'localhost' || 
                   window.location.hostname === '127.0.0.1';

if (isLocalhost && CONFIG.DEBUG_MODE) {
    console.log('ðŸ”§ Running in development mode');
    console.log('ðŸ“‹ Config:', CONFIG);
}